\version "2.24.0"


\paper {
  %between-system-padding = 0\mm
  staff-staff-spacing = #'((basic-distance . 2))
  %markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Sfinte Dumnezeule"
  %subtitle = "(variantă)"
  composer = \markup \center-column { "Gheorghe Cucu" \small 
  "(11.02.1882 - 24.08.1932)" } 
  meter = "Moderato"
  tagline=""
}

global = {
  \key c \major
  \autoBeamOff
  \time 3/2 
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Sfin -- te Dum -- ne -- ze -- u -- le,
  Sfin -- te ta -- re,
  Sfin -- te fă -- ră de moar -- te,
  mi -- lu -- ieş -- te- -- ne pe noi.
  
  \once \override LyricText.self-alignment-X = #-1
  "Mărire Tatălui şi Fiului şi Sfântului" Duh. 
  \once \override LyricText.self-alignment-X = #-1
  "Şi acum şi pururea şi în vecii vecilor. A - " min. __ 
  Sfin -- te fă -- ră de moar -- te,
  mi -- lu -- ieş -- te- -- ne pe noi.
  
  Sfin -- te Dum -- ne -- ze -- u -- le,
  Sfin -- te ta -- re,
  Sfin -- te fă -- ră de moar -- te,
  mi -- lu -- ieş -- te- -- ne pe noi.
}

tenorWords = \lyricmode {
  %"A_______"
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1  \skip 1 \skip 1 \skip 1
  %"A_____________________________________"
  %A __
}

bassWords = \lyricmode {
  Sfin -- te Dum -- ne -- ze -- u -- le,
  Sfin -- te făr' de moar -- te,
  mi -- lu -- ieş -- te- -- ne pe noi.
  \skip 1 \skip 1 \skip 1 \skip 1  
  
  Sfin -- te făr' de moar -- te,
  mi -- lu -- ieş -- te- -- ne pe noi.
  
  Sfin -- te Dum -- ne -- ze -- u -- le,
  Sfin -- te făr' de moar -- te,
  mi -- lu -- ieş -- te- -- ne pe noi.
}

sopMusic = \relative c'' {
  b2\rest^\mf c4 c d e f( e) d c^\<
  b c d\!( e) d1^\>
  e2\! d4^\< c d e f\!( e) d2^\> c4 d e\!
  d c b c2 %b4\rest
  \bar ":|." \break
  
  %g\breve 
  \mark "               Mărire Tatălui"
  
  %\once \omit Staff.TimeSignature
  %\time 8/4
  \cadenzaOn
  e\breve \bar"|" d2 \bar"|" d\breve \bar"|" \break e2( e1) \bar"|" 
  %\time 3/4
  \cadenzaOff
  e2 d4c d e f( e) d2 c4 d e d c b c2 \fermata
  
  \bar "|."
  
  
  \mark "     Puternic"
  b2\rest^\mf c4 c d e f( e) d c^\<
  b c d\!( e) d1^\>
  e2\! d4^\< c d e f\!( e) d2^\> c4 d e\!
  d c b c2 \fermata %b4\rest
  \bar ":|." 
  
  \bar "|."
}

altMusic = \relative c'' {
  b2\rest c4 c b c d( c) b a g a b( c) b1
  c2 b4 c b c d( c) b2 g4 g g g g g g2
    
  c\breve b2 b\breve c2 (c1)
  c2 b4 c b c d( c) b2 g4 g g g g g g2
    
  b2\rest c4 c b c d( c) b a g a b( c) b1
  c2 b4 c b c d( c) b2 g4 g g g g g g2
}

tenorMusic = \relative c' {
  g2^\markup "A_______________________________________________________________"( 
  g1)( g2)( g1)( g2)( g1)
  g2 g4 g g g g2 g e4 f g f e d e2

  g\breve \bar"|" g2 \bar"|" g\breve \bar"|" g2( g1)
  g2 g4 g g g g2 g e4 f g f e d e2
  
  g2^\markup "A___________________________________"( 
  g1)( g2)( g1)( g2)( g1)
  g2 g4 g g g g2 g e4 f g f e d e2
  
}


bassMusic = \relative c {
  d2\rest e4 e d c b c g1( g2)
  g'4 f e d c2( d4 e f e d c) g2
  g4 g g g g g c2
  
  c\breve \bar"|" g2 \bar"|" g\breve \bar"|" c2 g'4 f e d 
  c2( d4 e f e d c) g2 g4 g g g g g c2
  
  d2\rest e4 e d c b c g1( g2)
  g'4 f e d c2( d4 e f e d c) g2
  g4 g g g g g c2
}


myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \womenWords }
    >>
    \new Staff = "staff" <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\addlyrics { \tenorWords }
      \new Voice { \global \voiceTwo \bassMusic }
      \addlyrics { \bassWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}  

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}